%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%    Charge from field, in three coordinate systems


clear all;
close all;
syms EPS0
a = input('\nChoose coordinate system (1)Cartesian, (2)Spherical ,(3)Cylindrical : ');
switch a
    case 1
        syms x y z
        fprintf('\nVariables in Cartesian system are: x, y and z');
        fprintf('\nGive analytical expressions for E field components in terms of these variables');
        Ex = input('\nEx is : ');
        Ey = input('\nEy is : ');
        Ez = input('\nEz is : ');
        rho = EPS0*divCar(Ex,Ey,Ez);
        fprintf('Charge density is given by the following expression: ');
        pretty(rho);
    case 2
        syms r theta phi
        fprintf('\nVariables in Spherical system are: r, theta and phi');
        fprintf('\nGive analytical expressions for E field components in terms of these variables');
        Er = input('\nEr is : ');
        Et = input('\nEtheta is : ');
        Ep = input('\nEphi is : ');
        rho = EPS0*divSph(Er,Et,Ep);
        fprintf('Charge density is given by the following expression: ');
        pretty(rho);
    case 3
        syms r phi z
        fprintf('\nVariables in Cylindrical system are: r, phi and z');
        fprintf('\nGive analytical expressions for E field components in terms of these variables');
        Er = input('\nEr is : ');
        Ep = input('\nEphi is : ');
        Ez = input('\nEz is : ');
        rho = EPS0*divCyl(Er,Ep,Ez);
        fprintf('Charge density is given by the following expression: ');
        pretty(rho);
    otherwise
        fprintf('Incorrect input!');
end;